/* --------------------------------------------------------------
 icon_input.js 2018-09-14
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Icon Input Widget
 *
 * Turns normal input fields into input fields with a provided background image.
 *
 * ### Example
 *
 * The "icon-input" activates the widget and attaches the needed styles for the background image
 * which is provided by the `data-icon` attribute.
 *
 * ```html
 * <input data-gx-widget="icon_input" data-icon="url/to/image-file.png"/>
 * ```
 *
 * @todo Add automatic image dimension adjustment. Images - for example if they are too big in dimensions - won't scale correctly at the moment.
 *
 * @module Admin/Widgets/icon_input
 */
gx.widgets.module(
    'icon_input',

    ['xhr'],

    function (data) {

        'use strict';

        // ------------------------------------------------------------------------
        // VARIABLE DEFINITION
        // ------------------------------------------------------------------------

        var
            /**
             * Widget Reference
             *
             * @type {object}
             */
            $this = $(this),

            /**
             * Default Widget Options
             *
             * @type {object}
             */
            defaults = {},

            /**
             * Final Widget Options
             *
             * @type {object}
             */
            options = $.extend(true, {}, defaults, data),

            /**
             * Module Object
             *
             * @type {object}
             */
            module = {};

        // ------------------------------------------------------------------------
        // PRIVATE METHODS
        // ------------------------------------------------------------------------

        /**
         * Adds the dropdown functionality to the button.
         *
         * Developers can manually add new <li> items to the list in order to display more options to
         * the users.
         *
         * @private
         */
        const _setBackgroundImage = () => {
            const iconValue = $this.attr('data-icon');
            const langId = $this.attr('data-lang-id')

            if (undefined === iconValue && undefined === langId) {
                throw new Error('Whether data-lang-id or data-icon attribute is required!');
            }

            if (undefined !== langId) {
                jse.libs.xhr.get({
                    url: './admin.php?do=JSWidgetsAjax/iconInput&language_id=' + langId
                }).done(r => $this.css('background', 'url(' + r.iconUrl + ')' + ' no-repeat right 8px center / 20px white'));
            } else {
                $this.css('background', 'url(' + iconValue + ')' + ' no-repeat right 8px center white');
            }
        };

        // ------------------------------------------------------------------------
        // INITIALIZATION
        // ------------------------------------------------------------------------

        /**
         * Initialize method of the widget, called by the engine.
         */
        module.init = function (done) {
            _setBackgroundImage();
            done();
        };

        // Return data to module engine.
        return module;
    });
